/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.nhm.eui;

import ibm.nways.analysis.dpManager.DpmClientApplet;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridLayout;
import java.awt.Panel;
import java.awt.ScrollPane;
import java.util.Vector;

public abstract class NhmViewPage
extends ScrollPane {
    Vector components = new Vector();
    Component currentComponent;
    Panel panel = new Panel(new GridLayout(0, 1, 0, 0));

    public abstract String getTitle();

    public abstract void updateView();

    public abstract void updateComponent(Component var1);

    public abstract void recreateView();

    public abstract void unregisterForEvents(DpmClientApplet var1);

    public NhmViewPage() {
        this.add(this.panel);
    }

    public void removeAll() {
        this.panel.removeAll();
        this.components = new Vector();
        this.currentComponent = null;
    }

    public void addComponent(Component component) {
        this.panel.add(component);
        this.components.addElement(component);
    }

    public void validate() {
        super.validate();
        Container container = this.getParent();
        if (container != null) {
            this.setSize(container.getSize());
        }
    }

    public Component getCurrentComponent() {
        if (this.currentComponent == null && !this.components.isEmpty()) {
            this.currentComponent = (Component)this.components.elementAt(0);
        }
        return this.currentComponent;
    }

    public Vector getAllComponents() {
        return this.components;
    }

    public void setCurrentComponent(Component component) {
        if (this.components.contains(component)) {
            this.currentComponent = component;
        }
    }

    public void setCurrentComponent(int n) {
        Component component = (Component)this.components.elementAt(n);
        if (component != null) {
            this.currentComponent = component;
        }
    }

    public int numberOfComponents() {
        return this.components.size();
    }
}

